/*!
 * Fluid Design System for Elementor v0.0.0
 * Copyright © 2025
 * Author: Artem Semkin
 * License: GPL-3.0
 * Website: https://artemsemkin.com
 * Repository: https://github.com/artkrsk/fluid-design-system-for-elementor
 * Generated on: 2025-06-01
 */
(function(root, factory) {if (typeof define === 'function' && define.amd) {define(["jquery","elementor","backbone"], factory);} else if (typeof module === 'object' && module.exports) {module.exports = factory(require('jquery'), require('elementor'), require('backbone'));} else {root.ArtsFluidDesignSystem = factory(root.jQuery, root.elementor, root.Backbone);}}(typeof self !== 'undefined' ? self : this, function(jQuery, elementor, Backbone) {var ArtsFluidDesignSystem=(()=>{var Me=Object.defineProperty;var le=t=>{throw TypeError(t)};var Ue=(t,e,i)=>e in t?Me(t,e,{enumerable:!0,configurable:!0,writable:!0,value:i}):t[e]=i;var G=(t,e,i)=>Ue(t,typeof e!="symbol"?e+"":e,i),ke=(t,e,i)=>e.has(t)||le("Cannot "+i);var T=(t,e,i)=>e.has(t)?le("Cannot add the same private member more than once"):e instanceof WeakSet?e.add(t):e.set(t,i);var d=(t,e,i)=>(ke(t,e,"access private method"),i);var Z=class{constructor(){this.removedItems=new Map,this.recentRemovals=new Map,this.changedDocuments=new Map,this.REORDER_DETECTION_WINDOW=200,this.saveChangesDialog=null}markDocumentAsChanged(e){var i;(i=e==null?void 0:e.document)!=null&&i.id&&this.changedDocuments.set(e.document.id,!0)}clearDocumentChanges(e){this.changedDocuments.delete(e)}hasDocumentChanges(e){return this.changedDocuments.has(e)}setRecentRemoval(e){this.recentRemovals.set(e,Date.now())}hasRecentRemoval(e){return this.recentRemovals.has(e)}deleteRecentRemoval(e){this.recentRemovals.delete(e)}cleanupRecentRemovals(){let e=Date.now();this.recentRemovals.forEach((i,s)=>{e-i>this.REORDER_DETECTION_WINDOW&&this.recentRemovals.delete(s)})}hasRemovedItems(e){return this.removedItems.has(e)}markItemAsRemoved(e){this.removedItems.set(e,!0)}markItemAsRestored(e){this.removedItems.delete(e)}getSaveChangesDialog(e,i){var s,n,r,a;return this.saveChangesDialog||(this.saveChangesDialog=window.elementorCommon.dialogsManager.createWidget("confirm",{id:"elementor-fluid-spacing-save-changes-dialog",headerMessage:((s=window.ArtsFluidDSStrings)==null?void 0:s.saveChanges)||"Save Changes",message:((n=window.ArtsFluidDSStrings)==null?void 0:n.saveChangesMessage)||"Would you like to save the changes you've made?",position:{my:"center center",at:"center center"},strings:{confirm:((r=window.ArtsFluidDSStrings)==null?void 0:r.save)||"Save",cancel:((a=window.ArtsFluidDSStrings)==null?void 0:a.discard)||"Discard"}})),this.saveChangesDialog.onConfirm=e,this.saveChangesDialog.onCancel=i,this.saveChangesDialog.setSettings("hide",{onEscKeyPress:!1}),this.saveChangesDialog}},Ne=new Z,f=Ne;var ue="arts_fluid_design_system_presets",de={search:""};var g={REPEATER:{INSERT:"document/repeater/insert",REMOVE:"document/repeater/remove",MOVE:"document/repeater/move"},DOCUMENT:{UPDATE:"document/save/update",SAVE:"document/save/save"}};var E={SPACING:"fluid_spacing_presets",TYPOGRAPHY:"fluid_typography_presets"};var w="fluid-design-system-for-elementor";var y={REPEATER:{ADD:`${w}-hook-on-repeater-add`,REMOVE:`${w}-hook-on-repeater-remove`,REORDER:`${w}-hook-on-repeater-reorder`},DOCUMENT:{SAVE:`${w}-hook-on-document-save`},KIT:{SAVE:`${w}-hook-on-kit-save`}},I={DOCUMENT:"document"};var ce={HOOKS:`${w}-hooks`};var H={STYLE_ID:`${w}-style`,VAR_PREFIX:"--arts-fluid-preset--"};var j=class extends window.$e.modules.hookUI.After{getCommand(){return g.DOCUMENT.UPDATE}getId(){return y.DOCUMENT.SAVE}getContainerType(){return I.DOCUMENT}getConditions(){return!0}apply(e){e.document&&e.document.id&&f.clearDocumentChanges(e.document.id)}};var $=t=>{var e;return((e=t==null?void 0:t.attributes)==null?void 0:e._id)||null};var q,me,z=class z{static addControlSpinner(e){var r;if(!e)return null;let i=e.querySelector(".elementor-control-title"),s=e.querySelector(".elementor-control-responsive-switchers"),n=d(r=z,q,me).call(r);if(s)return s.insertAdjacentHTML("afterend",n),s.nextElementSibling;if(i)return i.insertAdjacentHTML("afterend",n),i.nextElementSibling}static showControlSpinner(e){if(!e)return null;let i=e.querySelector(".elementor-control-spinner");return i||(i=z.addControlSpinner(e)),i&&(i.style.display="block"),i}static hideControlSpinner(e){if(!e)return null;let i=e.querySelector(".elementor-control-spinner");return i&&(i.style.display="none"),i}};q=new WeakSet,me=function(){return'<span class="elementor-control-spinner" style="display: none;">&nbsp;<i class="eicon-spinner eicon-animation-spin"></i>&nbsp;</span>'},T(z,q);var ee=z,{addControlSpinner:ut,showControlSpinner:he,hideControlSpinner:Y}=ee;var te=class{constructor(){G(this,"presets",null);G(this,"request",null);G(this,"isPending",!1)}invalidate(){this.presets=null,this.request=null,this.isPending=!1}async getPresetsData(e){if(this.presets)return Y(e),this.presets;if(e&&e.closest(".elementor-control.e-units-fluid")&&he(e),this.isPending)return this.request.finally(()=>{Y(e)}),this.request;this.isPending=!0,this.request=new Promise((i,s)=>{window.elementor.ajax.addRequest(ue,{data:de,success:n=>{this.presets=n,i(n)},error:n=>{s(n)}})});try{return await this.request}catch(i){return null}finally{this.isPending=!1,Y(e)}}},ze=new te,V=ze;var W=class extends window.$e.modules.hookUI.After{getCommand(){return g.DOCUMENT.SAVE}getId(){return y.KIT.SAVE}getConditions(e){return e.document&&e.document.config&&e.document.config.type==="kit"}apply(){V.invalidate()}};var ie=class{constructor(){this.styleElement=null,this.styleElementId=H.STYLE_ID}createOrGetStyleElement(){var e,i,s;try{if(!((s=(i=(e=window.elementor)==null?void 0:e.$preview)==null?void 0:i[0])!=null&&s.contentDocument))return null;if(this.styleElement)return this.styleElement;let n=window.elementor.$preview[0].contentDocument,r=n.getElementById(this.styleElementId);return r instanceof HTMLElement?(this.styleElement=r,this.styleElement):(r=n.createElement("style"),r.id=this.styleElementId,n.head.appendChild(r),this.styleElement=r,this.styleElement)}catch(n){return null}}getCurrentRules(){let e=this.createOrGetStyleElement();return e?e.textContent.split("}").map(i=>i.trim()).filter(i=>i.length>0):[]}setRules(e){let i=this.createOrGetStyleElement();i&&(i.textContent=e.map(s=>s.endsWith("}")?s:`${s}}`).join(""))}unsetCssVariable(e){if(!this.createOrGetStyleElement())return!1;let n=`:root { ${`${H.VAR_PREFIX}${e}`}: unset !important; }`,r=this.getCurrentRules();return r.push(n),this.setRules(r),!0}restoreCssVariable(e){if(!this.createOrGetStyleElement())return!1;let s=`${H.VAR_PREFIX}${e}`,r=this.getCurrentRules().filter(a=>!a.includes(s));return this.setRules(r),!0}},Le=new ie,P=Le;var K=class extends window.$e.modules.hookUI.After{getCommand(){return g.REPEATER.INSERT}getId(){return y.REPEATER.ADD}getContainerType(){return I.DOCUMENT}getConditions(e){return e.name===E.SPACING||e.name===E.TYPOGRAPHY}apply(e){let{isRestored:i}=e,s=$(e.model);if(s){if(f.markDocumentAsChanged(e.container),i&&f.hasRemovedItems(s)){P.restoreCssVariable(s),f.markItemAsRestored(s);return}if(f.hasRecentRemoval(s)){P.restoreCssVariable(s),f.deleteRecentRemoval(s);return}f.cleanupRecentRemovals()}}};var X=class extends window.$e.modules.hookUI.Before{getCommand(){return g.REPEATER.REMOVE}getId(){return y.REPEATER.REMOVE}getContainerType(){return I.DOCUMENT}getConditions(e){return e.name===E.SPACING||e.name===E.TYPOGRAPHY}apply(e){let{container:i,name:s,index:n}=e;f.markDocumentAsChanged(i);let r=i.settings.get(s);if(!r)return!0;let a=r.at(n);if(!a)return!0;let o=$(a);return o&&(f.setRecentRemoval(o),f.markItemAsRemoved(o),P.unsetCssVariable(o)),!0}};var Q=class extends window.$e.modules.hookUI.After{getCommand(){return g.REPEATER.MOVE}getId(){return y.REPEATER.REORDER}getContainerType(){return I.DOCUMENT}getConditions(e){return e.name===E.SPACING||e.name===E.TYPOGRAPHY}apply(e){let{container:i,name:s,targetIndex:n}=e;f.markDocumentAsChanged(i);let r=i.settings.get(s);if(!r)return;let a=r.at(n);if(!a)return;let o=$(a);o&&P.restoreCssVariable(o)}};var se=class extends window.$e.modules.ComponentBase{getNamespace(){return ce.HOOKS}defaultHooks(){return this.importHooks({[g.REPEATER.INSERT]:K,[g.REPEATER.REMOVE]:X,[g.REPEATER.MOVE]:Q,[g.DOCUMENT.SAVE]:j,[g.DOCUMENT.UPDATE]:W})}},pe=()=>{window.$e.components.register(new se)};var Be=()=>window.elementor.modules.controls.RepeaterRow.extend({isFluidPresetRepeater(){var e,i;let t=(i=(e=this._parent)==null?void 0:e.model)==null?void 0:i.get("name");return t==="fluid_spacing_presets"||t==="fluid_typography_presets"},ui(){let t=this.constructor.__super__.ui.apply(this,arguments);return t.resetButton=".elementor-repeater-tool-reset",t.sortButton=".elementor-repeater-tool-sort",t},onChildviewRender(){this.constructor.__super__.onChildviewRender.apply(this,arguments),this.isFluidPresetRepeater()&&(this.ui.resetButton.length&&this.ui.resetButton.hide(),this.ui.removeButton.length&&this.ui.removeButton.data("e-global-type","fluid-preset").tipsy({title:()=>{var t;return((t=window.ArtsFluidDSStrings)==null?void 0:t.deleteFluidPreset)||"Delete Fluid Preset"},gravity:()=>"s"}))},onRemoveButtonClick(){var e,i,s,n;if(!this.isFluidPresetRepeater())return this.constructor.__super__.onRemoveButtonClick.apply(this,arguments);let t=((e=window.ArtsFluidDSStrings)==null?void 0:e.deletePresetMessage)||"You're about to delete a fluid preset. Note that if it's being used anywhere on your site, it will inherit default values.";this.confirmDeleteModal=elementorCommon.dialogsManager.createWidget("confirm",{className:"e-global__confirm-delete",headerMessage:((i=window.ArtsFluidDSStrings)==null?void 0:i.deleteFluidPreset)||"Delete Fluid Preset",message:'<i class="eicon-info-circle"></i> '+t,strings:{confirm:((s=window.ArtsFluidDSStrings)==null?void 0:s.delete)||"Delete",cancel:((n=window.ArtsFluidDSStrings)==null?void 0:n.cancel)||"Cancel"},hide:{onBackgroundClick:!1},onConfirm:()=>{this.trigger("click:remove")}}),this.confirmDeleteModal.show()}});function fe(){let t=Be();Object.assign(window.elementor.modules.controls,{FluidPresetRepeaterRow:t})}var Ge=()=>window.elementor.modules.controls["Global-style-repeater"].extend({initialize(){this.constructor.__super__.initialize.apply(this,arguments),this.isFluidSpacingTypographyRepeater()&&this.listenTo(this,"childview:render",this.onAfterChildViewRender)},isFluidSpacingTypographyRepeater(){return this.model.get("name")==="fluid_spacing_presets"||this.model.get("name")==="fluid_typography_presets"},onAfterChildViewRender(t){if(!this.isFluidSpacingTypographyRepeater())return;let e=t.$el.find(".elementor-control-popover-toggle-reset-label");e.length&&e.hide();let i=t.$el.find(".elementor-repeater-tool-remove:not(.elementor-repeater-tool-remove--disabled)");i.length&&(i.data("e-global-type","fluid-preset"),i.data("tipsy")&&(i.tipsy("hide"),jQuery.removeData(i.get(0),"tipsy")),i.tipsy({title:()=>{var s;return((s=window.ArtsFluidDSStrings)==null?void 0:s.deleteFluidPreset)||"Delete Fluid Preset"},gravity:()=>"s"}),i.off("click").on("click",s=>{var a,o,l,m;s.preventDefault(),s.stopPropagation();let n=((a=window.ArtsFluidDSStrings)==null?void 0:a.deletePresetMessage)||"You're about to delete a Fluid Preset. Note that if it's being used anywhere on your site, it will inherit default values.";elementorCommon.dialogsManager.createWidget("confirm",{className:"e-global__confirm-delete",headerMessage:((o=window.ArtsFluidDSStrings)==null?void 0:o.deleteFluidPreset)||"Delete Fluid Preset",message:'<i class="eicon-info-circle"></i> '+n,strings:{confirm:((l=window.ArtsFluidDSStrings)==null?void 0:l.delete)||"Delete",cancel:((m=window.ArtsFluidDSStrings)==null?void 0:m.cancel)||"Cancel"},hide:{onBackgroundClick:!1},onConfirm:()=>{t.trigger("click:remove")}}).show()}))},templateHelpers(){var e;let t=this.constructor.__super__.templateHelpers.call(this);return this.isFluidSpacingTypographyRepeater()&&(t.addButtonText=((e=window.ArtsFluidDSStrings)==null?void 0:e.addPreset)||"Add Preset"),t},getDefaults(){var e;let t=this.constructor.__super__.getDefaults.call(this);return this.isFluidSpacingTypographyRepeater()&&(t.title=`${((e=window.ArtsFluidDSStrings)==null?void 0:e.newPreset)||"New Preset"} #${this.children.length+1}`),t}});function ge(){let t=Ge();window.elementor.addControlView("global-style-repeater",t)}var D=(t,e,i={})=>{let s=document.createElement(t);return e&&(s.className=e),Object.entries(i).forEach(([n,r])=>s.setAttribute(n,r)),s};var b,J,re,C=class C{static createPresetOption(e,i){var x;let{id:s,value:n,title:r,min_size:a,min_unit:o,max_size:l,max_unit:m,min_screen_width_size:h,max_screen_width_size:_,min_screen_width_unit:p,max_screen_width_unit:S}=e,A=d(x=C,b,re).call(x,n,i,{"data-id":s,"data-title":r,"data-min-size":a,"data-min-unit":o,"data-max-size":l,"data-max-unit":m,"data-min-screen-width-size":h,"data-max-screen-width-size":_,"data-min-screen-width-unit":p,"data-max-screen-width-unit":S});return A.textContent=`${a}${o} ~ ${l}${m} ${r}`,A}static handleMixedUnitsInheritance(e,i){let{inheritedSize:s,sourceUnit:n,inheritedFrom:r,inheritedVia:a,inheritedDevice:o}=i;e.setAttribute("data-mixed-units","true"),e.setAttribute("data-inherited-title",name),r&&e.setAttribute("data-inherited-from",r),a&&e.setAttribute("data-inherited-via",a),o&&e.setAttribute("data-inherited-device",o);let l=n==="custom"?s:s?`${s}${n}`:"";n==="custom"&&e.setAttribute("data-custom-value","true"),e.setAttribute("data-title",l),l&&e.setAttribute("data-value-display",l),e.setAttribute("data-inherited-value","true"),e.textContent=l}static handleComplexPresetInheritance(e,i){var p;let{min_size:s,min_unit:n,max_size:r,max_unit:a,min_screen_width_size:o,max_screen_width_size:l,min_screen_width_unit:m,max_screen_width_unit:h,title:_}=i;return e.setAttribute("data-inherited-preset","true"),d(p=C,b,J).call(p,e,{"data-min-size":s,"data-min-unit":n,"data-max-size":r,"data-max-unit":a,"data-min-screen-width-size":o,"data-min-screen-width-unit":m,"data-max-screen-width-size":l,"data-max-screen-width-unit":h}),e.textContent=`${s}${n} ~ ${r}${a} ${_}`,e}static handleFluidInheritance(e,i){let{inheritedSize:s,inheritedFrom:n,inheritedVia:r,inheritedDevice:a}=i,o=C.getInheritedPresetSync(s);if(e.setAttribute("data-inherited-title",name),s&&e.setAttribute("data-value-display",s),n&&e.setAttribute("data-inherited-from",n),r&&e.setAttribute("data-inherited-via",r),a&&e.setAttribute("data-inherited-device",a),o)o.isComplex?C.handleComplexPresetInheritance(e,o):(e.setAttribute("data-inherited-value","true"),e.textContent=o.title);else{e.setAttribute("data-inherited-value","true");let l=s||name;e.setAttribute("data-title",l),e.textContent=l}}static handleStandardInheritance(e,{inheritedSize:i,sourceUnit:s,name:n}){var a;let r=i!==null&&s!==null?`${i}${s}`:n;return d(a=C,b,J).call(a,e,{"data-inherited-value":"true","data-title":r,"data-value-display":r}),e.textContent=r,e}static handleInheritOption(e,i,s,n){let{inheritedSize:r,inheritedUnit:a,sourceUnit:o}=s;return i===""&&e.classList.add("e-select-placeholder"),e.classList.add("option-inherit"),r!==null?o&&o!=="fluid"?C.handleMixedUnitsInheritance(e,{...s,name:n}):a==="fluid"&&r!==null?C.handleFluidInheritance(e,{...s,name:n}):C.handleStandardInheritance(e,{inheritedSize:r,sourceUnit:o,name:n}):e.textContent=n,e}static createSimpleOption(e,i,s,n){var a;let r=d(a=C,b,re).call(a,e,s);return e===""?C.handleInheritOption(r,s,n,i):r.textContent=i,r}static async buildSelectOptions(e,i){let s=await V.getPresetsData(i);if(!s)return e;e.classList.remove("is-loading");let n=e.querySelector(".elementor-loading-option");n&&n.remove();let r=e.getAttribute("data-value"),a={inheritedSize:e.getAttribute("data-inherited-size"),inheritedUnit:e.getAttribute("data-inherited-unit"),sourceUnit:e.getAttribute("data-source-unit"),inheritedFrom:e.getAttribute("data-inherited-from"),inheritedDevice:e.getAttribute("data-inherited-device"),inheritedVia:e.getAttribute("data-inherited-via")};for(let{name:o,value:l}of s)if(o){if(typeof l=="object"&&Array.isArray(l)){let m=D("optgroup",null,{label:o});for(let h of l){let _=C.createPresetOption(h,r);m.appendChild(_)}e.appendChild(m)}else if(typeof l=="string"){let m=C.createSimpleOption(l,o,r,a);e.appendChild(m)}}return e.classList.toggle("e-select-placeholder",r===""),e}static async getInheritedPreset(e){let i=await V.getPresetsData();if(!i)return null;for(let{name:s,value:n}of i)if(typeof n=="object"){for(let r of Object.values(n))if(e===r.value)return{...r,isComplex:!0}}else if(typeof n=="string"&&e===n)return{isComplex:!1,id:n,name:s};return null}static getInheritedPresetSync(e){let i=V.presets;if(!i)return null;for(let{name:s,value:n}of i)if(typeof n=="object"){for(let r of Object.values(n))if(e===r.value)return{...r,isComplex:!0}}else if(typeof n=="string"&&e===n)return{isComplex:!1,id:n,name:s};return null}};b=new WeakSet,J=function(e,i){Object.entries(i).forEach(([s,n])=>{n!=null&&e.setAttribute(s,n)})},re=function(e,i,s={}){var r;let n=D("option");return n.value=e,i===e&&n.setAttribute("selected","selected"),d(r=C,b,J).call(r,n,s),n},T(C,b);var ne=C,{buildSelectOptions:Ce,getInheritedPreset:jt,getInheritedPresetSync:_e}=ne;var u,v,R,O,oe,Ae,Se,we,ye,De,ve,Re,Ee,c=class c{static getTemplateSelect2(e,i){var n,r;if(!e.element)return e.text;let{element:s}=e;return s.value===""?d(n=c,u,ye).call(n,s,e.text):d(r=c,u,Ee).call(r,s,e.text,i)}static getSelect2DefaultOptions(){return{closeOnSelect:!0,dropdownAutoWidth:!0,theme:"default select2-container--width-auto",containerCssClass:"select2-selection--height-large",templateResult:e=>c.getTemplateSelect2(e,!0),templateSelection:e=>c.getTemplateSelect2(e,!1)}}};u=new WeakSet,v=function(e="",i=""){return jQuery(`
      <span class="select2-result-fluid-spacing-formatted ${e}">
        ${i}
      </span>
    `)},R=function(e){return`
      <span class="select2-result-fluid-spacing-formatted__header">
        ${e}
      </span>
    `},O=function(e){return`
      <span class="select2-result-fluid-spacing-formatted__footer">
        ${e}
      </span>
    `},oe=function(e){var i,s,n;return d(n=c,u,v).call(n,"select2-result-fluid-spacing-formatted--inherit",`
        ${d(i=c,u,R).call(i,`
          <span class="select2-result-fluid-spacing-formatted__value">${e}</span>
        `)}
        ${d(s=c,u,O).call(s,`
          <span class="select2-result-fluid-spacing-formatted__title">Inherit</span>
        `)}
      `)},Ae=function(e,i){var n,r,a;let s=e.getAttribute("data-inherited-title")||i||((n=window.ArtsFluidDSStrings)==null?void 0:n.inherit)||"Inherit";return d(a=c,u,v).call(a,"select2-result-fluid-spacing-formatted--inherit",d(r=c,u,R).call(r,`
        <span class="select2-result-fluid-spacing-formatted__title">${s}</span>
      `))},Se=function(e,i,s,n,r){var a,o,l;return d(l=c,u,v).call(l,"select2-result-fluid-spacing-formatted--inherit",`
        ${d(a=c,u,R).call(a,`
          <span class="select2-result-fluid-spacing-formatted__size">${e}${i}<span class="select2-result-fluid-spacing-formatted__size-divider"></span>${s}${n}</span>
        `)}
        ${d(o=c,u,O).call(o,`
          <span class="select2-result-fluid-spacing-formatted__title">${r}</span>
        `)}
      `)},we=function(e){var s,n;let i=_e(e);if(i&&i.isComplex){let{min_size:r,min_unit:a,max_size:o,max_unit:l,title:m}=i;return d(s=c,u,Se).call(s,r,a,o,l,m)}return d(n=c,u,oe).call(n,e)},ye=function(e,i){var n,r,a;let s=e.getAttribute("data-value-display");return s?e.getAttribute("data-inherited-preset")?d(n=c,u,we).call(n,s):d(r=c,u,oe).call(r,s):d(a=c,u,Ae).call(a,e,i)},De=function(e,i,s){var S,A,x,U,k,N;let n=e.getAttribute("data-custom-value")==="true",r=e.getAttribute("data-min-size"),a=e.getAttribute("data-min-unit"),o=e.getAttribute("data-max-size"),l=e.getAttribute("data-max-unit"),m=e.getAttribute("data-inherited-title");if(!r||!o){let L=i||s,B=d(A=c,u,v).call(A,"select2-result-fluid-spacing-formatted--inherit",d(S=c,u,R).call(S,`
        <span class="select2-result-fluid-spacing-formatted__title">${L}</span>
      `));return m&&L!==m&&B.append(d(x=c,u,O).call(x,`
          <span class="select2-result-fluid-spacing-formatted__title">${m}</span>
        `)),B}let h=n?i:r&&o?`${r}${a}<span class="select2-result-fluid-spacing-formatted__size-divider"></span>${o}${l}`:i||s,_=n?`<span class="select2-result-fluid-spacing-formatted__title select2-result-fluid-spacing-formatted__title--custom">${h}</span>`:r&&o?`<span class="select2-result-fluid-spacing-formatted__size">${h}</span>`:`<span class="select2-result-fluid-spacing-formatted__value">${h}</span>`,p=d(k=c,u,v).call(k,"select2-result-fluid-spacing-formatted--inherit",d(U=c,u,R).call(U,_));return m&&h!==m&&p.append(d(N=c,u,O).call(N,`
        <span class="select2-result-fluid-spacing-formatted__title">${m}</span>
      `)),p},ve=function(e,i,s,n,r,a){var h,_,p;let o=`${e}${i}<span class="select2-result-fluid-spacing-formatted__size-divider"></span>${s}${n}`,l=a.getAttribute("data-inherited-title"),m=d(_=c,u,v).call(_,"select2-result-fluid-spacing-formatted--inherit",d(h=c,u,R).call(h,`
        <span class="select2-result-fluid-spacing-formatted__title">${o}</span>
      `));return l&&o!==l&&m.append(d(p=c,u,O).call(p,`
        <span class="select2-result-fluid-spacing-formatted__title">${l}</span>
      `)),m},Re=function(e,i,s,n,r,a,o,l){var m,h,_,p,S,A,x;if(r&&(!e||!s))return d(h=c,u,v).call(h,"",d(m=c,u,R).call(m,`
        <span class="select2-result-fluid-spacing-formatted__title">${r}</span>
      `));if(r){let U=`${e}${i}<span class="select2-result-fluid-spacing-formatted__size-divider"></span>${s}${n}`,k=d(p=c,u,v).call(p,"",d(_=c,u,R).call(_,`
          <span class="select2-result-fluid-spacing-formatted__size">${U}</span>
        `));if(r!==U){let N=`<span class="select2-result-fluid-spacing-formatted__title">${r}</span>`;if(o){let L=l.getAttribute("data-min-screen-width-size")||"",B=l.getAttribute("data-min-screen-width-unit")||"",$e=l.getAttribute("data-max-screen-width-size")||"",Fe=l.getAttribute("data-max-screen-width-unit")||"";N+=`
            <span class="select2-result-fluid-spacing-formatted__divider"></span>
            <span class="select2-result-fluid-spacing-formatted__screen-width">${L}${B} \u2013 ${$e}${Fe}</span>
          `}k.append(d(S=c,u,O).call(S,N))}return k}return d(x=c,u,v).call(x,"",d(A=c,u,R).call(A,`
        <span class="select2-result-fluid-spacing-formatted__title">${a}</span>
      `))},Ee=function(e,i,s){var p,S,A;let n=e.getAttribute("data-inherited-preset"),r=e.getAttribute("data-inherited-value"),a=e.getAttribute("data-title")||"",o=e.getAttribute("data-min-size")||"",l=e.getAttribute("data-min-unit")||"",m=e.getAttribute("data-max-size")||"",h=e.getAttribute("data-max-unit")||"",_=e.getAttribute("data-value-display")||"";return r?d(p=c,u,De).call(p,e,_,a):n?d(S=c,u,ve).call(S,o,l,m,h,a,e):d(A=c,u,Re).call(A,o,l,m,h,a,i,s,e)},T(c,u);var ae=c,{getSelect2DefaultOptions:be}=ae;var F={isDestroyed:!1,initialize(){this.constructor.__super__.initialize.apply(this,arguments),this.isDestroyed=!1},ui(){let t=this.constructor.__super__.ui.apply(this,arguments);return t.selectControls=".elementor-control-fluid-selector",t.dimensions=".elementor-control-input-wrapper ul > li",t},async onRender(){this.constructor.__super__.onRender.call(this),this.hasFluidUnit()&&await this.renderFluidSelector()},onDestroy(){this.isDestroyed=!0,this.constructor.__super__.onDestroy.call(this)},hasRenderedFluidSelector(){return this.ui.selectControls.length>0},updatePlaceholderClassState(){var t;if((t=this.ui.selectControls)!=null&&t.length)for(let e of this.ui.selectControls){let s=e.value==="";e.classList.toggle("e-select-placeholder",s),s&&e.getAttribute("data-value")!==""&&e.setAttribute("data-value","")}},async renderFluidSelector(){this.isDestroyed||(this.renderFluidSelectElements(),this.addLoadingOptions(),this.createSelect2(),await this.populateSelectElements(),this.attachSelectElementsListeners())},addLoadingOptions(){if(!this.isDestroyed)for(let t of this.ui.selectControls){if(this.isDestroyed)return;let e=D("option","elementor-loading-option",{value:"",disabled:"disabled",selected:"selected"});e.textContent="Loading...",t.appendChild(e),t.classList.add("is-loading")}},createSelect2(){if(this.isDestroyed)return;let t=be();for(let e of this.ui.selectControls){if(this.isDestroyed)return;jQuery(e).select2(t).on("change",()=>{this.onSelectChange(e)})}},async populateSelectElements(){if(!this.isDestroyed)for(let t of this.ui.selectControls){if(this.isDestroyed)return;await Ce(t,this.el),jQuery(t).trigger("change.select2")}},onSelectChange(t){let e=t.value,i=e==="",s=t.getAttribute("data-setting"),n={unit:"fluid",[s]:e};t.classList.toggle("e-select-placeholder",i),t.setAttribute("data-value",e),this.setValue(n),this.isLinkedDimensions()?this.handleLinkedDimensionsChange(t,e,i):this.handleUnlinkedDimensionsChange(s,e),this.updateDimensions()},handleLinkedDimensionsChange(t,e,i){this.ui.controls.val(e);for(let s of this.ui.selectControls)s!==t&&(s.value=e,s.setAttribute("data-value",e),s.classList.toggle("e-select-placeholder",i),jQuery(s).trigger("change.select2"))},handleUnlinkedDimensionsChange(t,e){let i=this.ui.controls.filter(`[data-setting="${t}"]`);i.val(e),i.trigger("change")},updateUnitChoices(){let t=this.getControlValue("unit");this.ui.unitSwitcher.attr("data-selected",t).find("span").html(t),this.$el.toggleClass("e-units-custom",this.isCustomUnit()),this.$el.toggleClass("e-units-fluid",this.isFluidUnit());let e=this.isCustomUnit()?"text":"number";this.ui.controls.attr("type",e),this.isFluidUnit()&&this.updatePlaceholderClassState()},onLinkDimensionsClicked(t){if(t.preventDefault(),t.stopPropagation(),this.ui.link.toggleClass("unlinked"),this.setValue("isLinked",!this.ui.link.hasClass("unlinked")),this.isLinkedDimensions()){let e=this.ui.controls.eq(0).val();this.ui.controls.val(e);for(let i of this.ui.selectControls)i.value=e,jQuery(i).trigger("change.select2")}this.updateDimensions()},renderFluidSelectElements(){if(!this.isDestroyed){(!this.ui.selectControls||!Array.isArray(this.ui.selectControls))&&(this.ui.selectControls=[]);for(let t of this.ui.dimensions){let e=t.querySelector('input[type="text"], input[type="number"]'),i=t.querySelector("label");if(!e||!i)continue;let s=t.querySelector(".elementor-control-fluid-selector"),n=t.querySelector(".elementor-control-fluid-selector-container");(!s||!n)&&this.createFluidSelector(t,e,i)}}},createFluidSelector(t,e,i){let s=e.dataset.setting,n=D("div","elementor-control-fluid-selector-container"),r=D("select","elementor-control-fluid-selector",{"data-setting":s,"data-value":e.value});this.setupInheritanceAttributes(r,s),n.appendChild(r),this.ui.selectControls.push(r),t.appendChild(n),t.appendChild(i)},setupInheritanceAttributes(t,e){let i=this.model.get("name");if(i&&/_(?!.*_)(.+)$/.test(i)){let n=this.getParentControlValue();n&&this.setInheritanceAttributes(t,n,e)}},setInheritanceAttributes(t,e,i){let s=e[i],n=e.unit,r=e.__inheritedFrom||"parent",a=e.__directParentDevice,o=e.__sourceUnit;s!==void 0&&t.setAttribute("data-inherited-size",s),n&&t.setAttribute("data-inherited-unit",n),o&&t.setAttribute("data-source-unit",o),t.setAttribute("data-inherited-from",r),a&&a!==r&&t.setAttribute("data-inherited-via",a);let l=r.charAt(0).toUpperCase()+r.slice(1);l==="Desktop"&&(l="Default"),t.setAttribute("data-inherited-device",l)},getParentControlValue(){if(!this.model.get("responsive"))return null;try{let t=this.model.get("name"),e=t,i="",s=window.elementor.breakpoints.getActiveBreakpointsList({largeToSmall:!0,withDesktop:!0});for(let n of s)if(n!=="desktop"&&t.endsWith("_"+n)){e=t.replace("_"+n,""),i=n;break}return i?i==="widescreen"?this.handleWidescreenInheritance(e):this.handleStandardInheritance(e,i,s):null}catch(t){return null}},handleWidescreenInheritance(t){let e=this._getControlValue(t);return e?{...e,__inheritedFrom:"desktop",__directParentDevice:"desktop",__inheritPath:["desktop"],__sourceUnit:e.unit}:null},handleStandardInheritance(t,e,i){let s=i.indexOf(e),n=i.slice(0,s),r=[],a="",o=n[n.length-1],l=o==="desktop"?t:t+"_"+o;a=o;let m=this._getControlValue(l);return r.push(o),!m||this.isEmptyValue(m)?this.findNonEmptyAncestorValue(t,n,r,a):{...m,__inheritedFrom:o,__directParentDevice:a,__inheritPath:r,__sourceUnit:m.unit}},findNonEmptyAncestorValue(t,e,i,s){for(let o=e.length-2;o>=0;o--){let l=e[o],m=l==="desktop"?t:t+"_"+l,h=this._getControlValue(m);if(i.unshift(l),h&&!this.isEmptyValue(h))return{...h,__inheritedFrom:l,__directParentDevice:s,__inheritPath:i,__sourceUnit:h.unit}}let n=e[e.length-1],r=n==="desktop"?t:t+"_"+n,a=this._getControlValue(r);return a?{...a,__inheritedFrom:n,__directParentDevice:s,__inheritPath:i,__sourceUnit:a.unit}:null},isEmptyValue(t){return!t||Object.keys(t).length===0},_getControlValue(t){var i,s;if((i=this.options)!=null&&i.elementSettingsModel){let n=this.options.elementSettingsModel.get(t);if(n)return n}if((s=this.container)!=null&&s.settings){let n=this.container.settings.get(t);if(n)return n}let e=this.model.get("settings");if(e!=null&&e.get){let n=e.get(t);if(n)return n}return null},attachSelectElementsListeners(){if(!this.isDestroyed)for(let t of this.ui.selectControls){if(this.isDestroyed)return;t.addEventListener("change",this.onSelectChange.bind(this,t))}},getCurrentUnit(){return this.getControlValue("unit")},isFluidUnit(){return this.getCurrentUnit()==="fluid"},hasFluidUnit(){let t=this.model.get("size_units");return t&&t.includes("fluid")},isCustomUnit(){let t=this.getCurrentUnit();return this.isFluidUnit()||t==="custom"}};var M={getStyleValue:(t,e)=>{let i=window._.isObject(e)?e[t.toLowerCase()]:"";return t==="UNIT"&&(i==="fluid"||i==="custom")&&(i="__EMPTY__"),i}};var xe={isEmptyValue(t){return t?["top","right","bottom","left"].every(e=>!t[e]||t[e]===""):!0}};var He=()=>window.elementor.modules.controls.Dimensions.extend({...F,...xe},{...M});function Ie(){let t=He();window.elementor.addControlView("dimensions",t)}var Pe={isEmptyValue(t){return t?["column","row"].every(e=>!t[e]||t[e]===""):!0}};var je=()=>window.elementor.modules.controls.Gaps.extend({...F,...Pe},{...M});function Ve(){let t=je();window.elementor.addControlView("gaps",t)}var Oe={renderFluidSelectElements(){(!this.ui.selectControls||!Array.isArray(this.ui.selectControls))&&(this.ui.selectControls=[]);let t=this.el.querySelector(".elementor-control-input-wrapper");if(!t)return;let e=t.querySelector('input[type="text"], input[type="number"]');if(!e)return;let i=t.querySelector(".elementor-control-fluid-selector"),s=t.querySelector(".elementor-control-fluid-selector-container");(!i||!s)&&this._createSliderFluidSelector(t,e)},_createSliderFluidSelector(t,e){let i=e.dataset.setting,s=D("div","elementor-control-fluid-selector-container"),n=D("select","elementor-control-fluid-selector",{"data-setting":i,"data-value":e.value});this._setupSliderInheritanceAttributes(n),s.appendChild(n),this.ui.selectControls.push(n),t.appendChild(s)},_setupSliderInheritanceAttributes(t){let e=this.model.get("name");if(e&&/_(?!.*_)(.+)$/.test(e)){let s=this.getParentControlValue();s&&this._setSliderInheritanceAttributes(t,s)}},_setSliderInheritanceAttributes(t,e){var o;let i=e.size,s=e.unit,n=e.__sourceUnit||s,r=e.__inheritedFrom||"parent";i!==void 0&&t.setAttribute("data-inherited-size",i),s&&t.setAttribute("data-inherited-unit",s),n&&t.setAttribute("data-source-unit",n),t.setAttribute("data-inherited-from",r),e.__directParentDevice&&e.__directParentDevice!==r&&t.setAttribute("data-inherited-via",e.__directParentDevice);let a=r.charAt(0).toUpperCase()+r.slice(1);if(a==="Desktop"&&(a="Default"),t.setAttribute("data-inherited-device",a),i!==void 0){let l;n==="custom"||n==="fluid"?l=i:(l=`${i}${n}`,t.setAttribute("data-mixed-units","true")),t.setAttribute("data-value-display",l),t.setAttribute("data-title",l),((o=e.__inheritPath)==null?void 0:o.length)>0&&t.setAttribute("data-inherit-path",e.__inheritPath.join(","))}},isEmptyValue(t){return t?t.size===""||t.size===null||t.size===void 0:!0},onSelectChange(t){let e=t.value,i=e==="",s={unit:"fluid",size:e};t.setAttribute("data-value",e),t.classList.toggle("e-select-placeholder",i),this.setValue(s),this.ui.input.val(e),this.ui.input.trigger("change")},updateUnitChoices(){let t=this.getControlValue("unit");this.ui.unitSwitcher.attr("data-selected",t).find("span").html(t),this.$el.toggleClass("e-units-custom",this.isCustomUnit()),this.$el.toggleClass("e-units-fluid",this.isFluidUnit());let e=this.isCustomUnit()?"text":"number";this.isCustomUnit()?this.destroySlider():this.initSlider(),this.isMultiple()||this.ui.input.attr("type",e),this.isFluidUnit()&&this.updatePlaceholderClassState()}};var qe=()=>window.elementor.modules.controls.Slider.extend({...F,...Oe},{...M});function Te(){let t=qe();window.elementor.addControlView("slider",t)}window.addEventListener("elementor/init-components",()=>{pe()});window.addEventListener("elementor/init",()=>{fe(),ge(),Ie(),Ve(),Te()});})();
return ArtsFluidDesignSystem;}));